<?php

	class ProdutoController extends Controller
		{

    	/**
     	 * Lista de Cartórios
       */
    	public function listar()
    		{
    		$pagina = 1;
			if ($this->request->p)
				{
				$pagina = $this->request->p;
				}
			$produtos = Produto::all();
			$visao = new Visao();
			$visao->visualizar("produtos");
			if ($produtos)
				{
				$ant = $pagina-1;
				$i=($ant*limite);
				foreach ($produtos as $produto) 
					{
					$visao->setCurrentBlock("DADOS");
					$visao->setVariable("id",$produto->id);
					$visao->setVariable("nome",$produto->nome);
					$visao->setVariable("pagina",$pagina);
					$visao->parseCurrentBlock("DADOS");
					$i++;          	
					}
				 $visao->setVariable("primeiro",(($ant*limite)+1));
				 $visao->setVariable("contagem",$i);
				 $visao->setVariable("total",Produto::count());
				 if ($ant < 1)
					{
					$visao->setVariable("disabled_a","disabled");
					$ant = 1;
					}
				 else 
					{
					$visao->setVariable("disabled_a","");
					}
				 $visao->setVariable("pagina_a",$ant);
				 $total_p = ceil(Produto::count()/limite);
				 $saltar = 0;
				 for ($p=1; $p <= $total_p; $p++)
					{
					//echo ($saltar);
					$visao->setCurrentBlock("PAGINAS");
					$visao->parseCurrentBlock("PAGINAS");
					if ($total_p > 7)
						{
						if (($p == 5)&&($saltar == 0))
							{
							$visao->setVariable("active","disabled");
							$visao->setVariable("pagina_n","..");
							if ($pagina > 2)
								{
								$p = $pagina - 2; 
								$saltar = $pagina + 2;
								}
							else 
								{
								$p = $total_p - 5;
								}
							continue;
							}
						if ($p == $saltar)
							{
							$visao->setVariable("active","disabled");
							$visao->setVariable("pagina_n","..");
							$p = $total_p - 5;
							continue;
							}
						}
					if ($p == $pagina)
						{
						$visao->setVariable("active","active");
						}
					else 
						{
						$visao->setVariable("active","");
						}
					$visao->setVariable("pagina_n",$p);
					}
				 if ($pagina < $total_p)
					{
					$prox = $pagina+1;
					$visao->setVariable("disabled_p","");
					}
				 else 
					{
					$prox = $total_p;
					$visao->setVariable("disabled_p","disabled");
					}
				 $visao->setVariable("pagina_p",$prox);
				 }
			  else 
				{
				$visao->setVariable("msg","Sem dados para mostrar");
				}
    		}
    		
  	
    	public function criar($dd)
    		{
    		$visao = new Visao();
			$visao->visualizar("form_produto");
			$visao->setVariable("titulo","Cadastro de produto"); 
			$visao->setVariable("acao","salvar");
			$visao->setVariable("txt_acao","Salvar");
    		}

    	public function editar($dd)
    		{
        	$produto = Produto::find($dd['id']);
			$visao = new Visao();
			$visao->visualizar("form_produto");
			$visao->setVariable("titulo","Atualização de produto"); 
			$visao->setVariable("acao","atualizar");
			$visao->setVariable("txt_acao","Atualizar");
			$visao->setVariable("id",$produto->id);
			$visao->setVariable("nome",$produto->nome);
			$visao->setVariable("pagina",$dd['p']);
    		}


    	public function salvar($dd)
    		{
        	$produto = new Produto;
        	$produto->nome = $dd['nome'];
        	if ($produto->save(0)) 
        		{
				return $this->listar();
        		}
    		}

    	public function atualizar($dd)
    		{
        	$produto = Produto::find($dd['id']);
        	$produto->nome = $dd['nome'];
			$visao = new Visao();
			$visao->visualizar("aviso");
        	if ($produto->save(1))
				{
				$visao->setVariable("tipo","Sucesso");
				$visao->setVariable("mensagem","Produto atualizado!");
				return $this->listar();
				}
			else
				{
				$visao->setVariable("tipo","Erro");
				$visao->setVariable("mensagem","Produto não atualizado!\nVerifique");
				return $this->editar($dd);
				}
    		}


    	public function deletar($dd)
    		{
        	$produto = Produto::destroy($dd['id']);
			$visao = new Visao();
			$visao->visualizar("aviso");
			if ($produto)
				{
				$visao->setVariable("tipo","Sucesso");
				$visao->setVariable("mensagem","Produto deletado!");
				}
			else
				{
				$visao->setVariable("tipo","Erro");
				$visao->setVariable("mensagem","Produto não deletado!\nRetire ele das Listas primeiro");
				}
        	return $this->listar();
    		}
    		
		};