<?php

	class ListaController extends Controller
		{

    	/**
     	 * Lista de Cartórios
       */
    	public function listar()
    		{
    		$pagina = 1;
    		if ($this->request->p)
    			{
    			$pagina = $this->request->p;
    			}
        	$listas = Lista::all();
			$visao = new Visao();
			$visao->visualizar("listas");
			if ($listas)
				{
				$ant = $pagina-1;
				$i=($ant*limite);
				foreach ($listas as $lista) 
					{
					$visao->setCurrentBlock("DADOS");
					$visao->setVariable("id",$lista->id);
					$visao->setVariable("nome",$lista->nome);
					$itens = Itens::count($lista->id);
					$visao->setVariable("qtd_itens",$itens);
					$visao->parseCurrentBlock("DADOS");
					$i++;          	
					}
				 $visao->setVariable("primeiro",(($ant*limite)+1));
				 $visao->setVariable("contagem",$i);
				 $visao->setVariable("total",Lista::count());
				 if ($ant < 1)
					{
					$visao->setVariable("disabled_a","disabled");
					$ant = 1;
					}
				 else 
					{
					$visao->setVariable("disabled_a","");
					}
				 $visao->setVariable("pagina_a",$ant);
				 $total_p = ceil(Lista::count()/limite);
				 $saltar = 0;
				 for ($p=1; $p <= $total_p; $p++)
					{
					//echo ($saltar);
					$visao->setCurrentBlock("PAGINAS");
					$visao->parseCurrentBlock("PAGINAS");
					if ($total_p > 7)
						{
						if (($p == 5)&&($saltar == 0))
							{
							$visao->setVariable("active","disabled");
							$visao->setVariable("pagina_n","..");
							if ($pagina > 2)
								{
								$p = $pagina - 2; 
								$saltar = $pagina + 2;
								}
							else 
								{
								$p = $total_p - 5;
								}
							continue;
							}
						if ($p == $saltar)
							{
							$visao->setVariable("active","disabled");
							$visao->setVariable("pagina_n","..");
							$p = $total_p - 5;
							continue;
							}
						}
					if ($p == $pagina)
						{
						$visao->setVariable("active","active");
						}
					else 
						{
						$visao->setVariable("active","");
						}
					$visao->setVariable("pagina_n",$p);
					}
				 if ($pagina < $total_p)
					{
					$prox = $pagina+1;
					$visao->setVariable("disabled_p","");
					}
				 else 
					{
					$prox = $total_p;
					$visao->setVariable("disabled_p","disabled");
					}
				 $visao->setVariable("pagina_p",$prox);
				 }
			  else 
				{
				$visao->setVariable("msg","Sem dados para mostrar");
				}
    		}
    		
    	public function criar()
    		{
    		$visao = new Visao();
			$visao->visualizar("form_lista");
			$visao->setVariable("titulo","Cadastro de lista"); 
			$visao->setVariable("acao","salvar");
			$visao->setVariable("txt_acao","Salvar");
    		}


    	public function editar($dd)
    		{
        	$lista = Lista::find($dd['id']);
			$visao = new Visao();
			$visao->visualizar("form_lista");
			$visao->setVariable("titulo","Atualização do Nome Lista"); 
			$visao->setVariable("acao","atualizar");
			$visao->setVariable("txt_acao","Atualizar");
			$visao->setVariable("id",$lista->id);
			$visao->setVariable("nome",$lista->nome);
			$visao->setVariable("pagina",$dd['p']);
    		}


    	public function salvar($dd)
    		{
        	$lista = new Lista;
        	$lista->nome = $dd['nome'];
        	if ($lista->save(0)) 
        		{
				return $this->listar();
        		}
    		}

    	public function atualizar()
    		{
        	$lista = Lista::find($dd['id']);
        	$lista->nome = $dd['nome'];
			$visao = new Visao();
			$visao->visualizar("aviso");
        	if ($lista->save(1))
				{
				$visao->setVariable("tipo","Sucesso");
				$visao->setVariable("mensagem","Nome da Lista atualizado!");
				return $this->listar();
				}
			else
				{
				$visao->setVariable("tipo","Erro");
				$visao->setVariable("mensagem","Nome da Lista não atualizado!\nVerifique");
				return $this->editar($dd);
				}
    		}


    	public function deletar($dd)
    		{
        	$lista = Lista::destroy($dd['id']);
			$visao = new Visao();
			$visao->visualizar("aviso");
			if ($lista)
				{
				$visao->setVariable("tipo","Sucesso");
				$visao->setVariable("mensagem","Lista deletado!");
				}
			else
				{
				$visao->setVariable("tipo","Erro");
				$visao->setVariable("mensagem","Lista não deletado!\nRetire os Itens da Lista primeiro");
				}
        	return $this->listar();
    		}
    		
		};