<?php

	class ItensController extends Controller
		{

    	/**
     	 * Lista de Cartórios
       */
    	public function listar($dd)
    		{
    		$pagina = 1;
    		if (isset($dd['p']))
    			{
    			$pagina = (int)$dd['p'];
    			}
			$lista = Lista::find($dd['lista']);
			//var_dump($lista);
        	$itens = Itens::all($dd['lista']);
			$visao = new Visao();
			$visao->visualizar("itens");
			$visao->setVariable("nome_lista",$lista->nome);
			$visao->setVariable("lista",$dd['lista']);
			if ($itens)
				{
				$ant = $pagina-1;
				$i=($ant*limite);
				$seq = 1;
				foreach ($itens as $item) 
					{
					$visao->setCurrentBlock("DADOS");
					$visao->setVariable("seq",$seq);
					$produto = Produto::find($item->id_produto);
					$visao->setVariable("nome",$produto->nome);
					$visao->setVariable("quantidade",$item->quantidade);
					$visao->setVariable("id",$item->id);
					$visao->setVariable("pagina",$pagina);
					$visao->parseCurrentBlock("DADOS");
					$i++;          	
					$seq++;
					}
				 $visao->setVariable("primeiro",(($ant*limite)+1));
				 $visao->setVariable("contagem",$i);
				 $visao->setVariable("total",Itens::count($dd['lista']));
				 if ($ant < 1)
					{
					$visao->setVariable("disabled_a","disabled");
					$ant = 1;
					}
				 else 
					{
					$visao->setVariable("disabled_a","");
					}
				 $visao->setVariable("pagina_a",$ant);
				 $total_p = ceil(Itens::count($dd['lista'])/limite);
				 $saltar = 0;
				 for ($p=1; $p <= $total_p; $p++)
					{
					//echo ($saltar);
					$visao->setCurrentBlock("PAGINAS");
					$visao->parseCurrentBlock("PAGINAS");
					if ($total_p > 7)
						{
						if (($p == 5)&&($saltar == 0))
							{
							$visao->setVariable("active","disabled");
							$visao->setVariable("pagina_n","..");
							if ($pagina > 2)
								{
								$p = $pagina - 2; 
								$saltar = $pagina + 2;
								}
							else 
								{
								$p = $total_p - 5;
								}
							continue;
							}
						if ($p == $saltar)
							{
							$visao->setVariable("active","disabled");
							$visao->setVariable("pagina_n","..");
							$p = $total_p - 5;
							continue;
							}
						}
					if ($p == $pagina)
						{
						$visao->setVariable("active","active");
						}
					else 
						{
						$visao->setVariable("active","");
						}
					$visao->setVariable("pagina_n",$p);
					}
				 if ($pagina < $total_p)
					{
					$prox = $pagina+1;
					$visao->setVariable("disabled_p","");
					}
				 else 
					{
					$prox = $total_p;
					$visao->setVariable("disabled_p","disabled");
					}
				 $visao->setVariable("pagina_p",$prox);
				 }
			  else 
				{
				$visao->setVariable("msg","Sem dados para mostrar");
				}
			$visao->setVariable("lista",$dd['lista']);
    		}
    		
    	
    	public function criar($dd)
    		{
    		//print_r($dd);
    		$visao = new Visao();
			$visao->visualizar("form_item");
			$visao->setVariable("titulo","Cadastro de item"); 
			$visao->setVariable("acao","salvar");
			$visao->setVariable("txt_acao","Salvar");
			$visao->setVariable("lista",$dd['lista']);
			$produtos = Produto::all();
			if ($produtos)
				{
				foreach($produtos as $produto)
					{
					$visao->setCurrentBlock("Produto");
					$visao->parseCurrentBlock("Produto");
					$visao->setVariable("id_produto",$produto->id);
					$visao->setVariable("nome_produto",$produto->nome);
					$visao->setVariable("selecionado","");
					}
				}
			else
				{
				$visao->setCurrentBlock("Produto");
				$visao->parseCurrentBlock("Produto");
				$visao->setVariable("nome_produto","Não há produtos Cadastrados!");
				$visao->setVariable("selecionado","selected");
				}
			$visao->setVariable("lista",$dd['lista']);
    		}


    	public function editar($dd)
    		{
        	$item = Itens::find($dd['id']);
			$visao = new Visao();
			$visao->visualizar("form_item");
			$visao->setVariable("titulo","Atualização do Item Lista"); 
			$visao->setVariable("acao","atualizar");
			$visao->setVariable("txt_acao","Atualizar");
			$visao->setVariable("id",$item->id);
			$visao->setVariable("lista",$item->id_lista);
			$produtos = Produto::all();
			if ($produtos)
				{
				foreach($produtos as $produto)
					{
					$visao->setCurrentBlock("Produto");
					$visao->parseCurrentBlock("Produto");
					$visao->setVariable("id_produto",$produto->id);
					$visao->setVariable("nome_produto",$produto->nome);
					if ($produto->id == $item->id_produto)
						{
						$visao->setVariable("selecionado","selected");
						}
					else 
						{
						$visao->setVariable("selecionado","");
						}
					}
				}
			$visao->setVariable("quantidade",$item->quantidade);
			$visao->setVariable("pagina",$dd['p']);
			$visao->setVariable("lista",$item->id_lista);
    		}


    	public function salvar($dd)
    		{
        	$item = new Itens;
        	$item->id_lista = $dd['id_lista'];
        	$item->id_produto = $dd['id_produto'];
        	$item->quantidade = $dd['quantidade'];
        	if ($item->save(0)) 
        		{
				return $this->listar($dd);
        		}
    		}

     	public function atualizar($dd)
    		{
        	$item = Itens::find($dd['id']);
        	$item->id_produto = $dd['id_produto'];
        	$item->quantidade = $dd['quantidade'];
			$visao = new Visao();
			$visao->visualizar("aviso");
        	if ($item->save(1))
				{
				$visao->setVariable("tipo","Sucesso");
				$visao->setVariable("mensagem","Item da Lista atualizado!");
				return $this->listar($dd);
				}
			else
				{
				$visao->setVariable("tipo","Erro");
				$visao->setVariable("mensagem","Item da Lista não atualizado!\nVerifique");
				return $this->editar($dd);
				}
    		}

    	public function deletar($dd)
    		{
        	$item = Itens::destroy($dd['id']);
			$visao = new Visao();
			$visao->visualizar("aviso");
			if ($item)
				{
				$visao->setVariable("tipo","Sucesso");
				$visao->setVariable("mensagem","Item deletado!");
				}
			else
				{
				$visao->setVariable("tipo","Erro");
				$visao->setVariable("mensagem","Item não deletado!\nVerifique");
				}
        	return $this->listar($dd);
    		}
    		
		};