<?php

class Funcoes
	{
	/**
     * Tornar valores aceitos para sintaxe SQL
     * @param type $dados
     * @return string
     */
	protected function escapar($dados)
    	{
      if (is_string($dados) & !empty($dados)) 
      	{
         return "'".addslashes($dados)."'";
        	} 
      elseif (is_bool($dados)) 
      	{
         return $dados ? 'TRUE' : 'FALSE';
        	} 
      elseif ($dados !== '') 
      	{
         return $dados;
        	} 
      else 
      	{
         return 'NULL';
        	}
    	}

    /**
     * Verifica se dados são próprios para ser salvos
     * @param array $dados
     * @return array
     */
   protected function preparar($dados)
    	{
      $resultado = array();
      foreach ($dados as $k => $v) 
      	{
         if (is_scalar($v)) 
         	{
            $resultado[$k] = $this->escapar($v);
            }
        	}
      return $resultado;
    	}
    	
   static public function data_extenso($dia)
   	{
   	$semana = array ("Domingo","Segunda-Feira","Terça-Feira","Quarta-Feira","Quinta-Feira","Sexta-Feira","Sábado");
   	$meses = array (12,"Janeiro","Fevereiro","Março","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro");
   	$dados = explode (" ",$dia);
      $data = explode ("-",$dados[0]);
      $time = explode (":",$dados[1]);
      $dia = date('j',mktime($time[0],$time[1],$time[2],$data[1],$data[2],$data[0]));
		$d_semana = $semana[date('w',mktime($time[0],$time[1],$time[2],$data[1],$data[2],$data[0]))];
		$mes = $meses[date('n',mktime($time[0],$time[1],$time[2],$data[1],$data[2],$data[0]))];
		$ano = date('Y',mktime($time[0],$time[1],$time[2],$data[1],$data[2],$data[0]));
		$data_ext = $d_semana.", ".$dia." de ".$mes." de ".$ano;
		
		return $data_ext;
   	}
	};
?>